<?php
require('fpdf.php');

class PDF extends FPDF
{
    function __construct($orientation = 'P', $unit = 'mm', $size = 'A4')
    {
        parent::__construct($orientation, $unit, $size);
        
        // Add custom fonts
        $this->AddFont('Poppins', '', 'font/Poppins-Regular.php');
        $this->AddFont('Poppins', 'B', 'font/Poppins-Bold.php');
    }
}

$pdf = new PDF();
$pdf->AddPage();

// Test Poppins Regular
$pdf->SetFont('Poppins', '', 14);
$pdf->Cell(0, 10, 'Test Poppins Regular Font', 0, 1);

// Test Poppins Bold
$pdf->SetFont('Poppins', 'B', 14);
$pdf->Cell(0, 10, 'Test Poppins Bold Font', 0, 1);

// Test Times Regular
$pdf->SetFont('Times', '', 14);
$pdf->Cell(0, 10, 'Test Times Regular Font', 0, 1);

// Test Times Bold
$pdf->SetFont('Times', 'B', 14);
$pdf->Cell(0, 10, 'Test Times Bold Font', 0, 1);

// Test Times Italic
$pdf->SetFont('Times', 'I', 14);
$pdf->Cell(0, 10, 'Test Times Italic Font', 0, 1);

$pdf->Output('I', 'font-test.pdf');
?>