<?php
include('../config/db.php');

// Mengambil data permohonan yang sudah disetujui khusus untuk Perorangan
$sql = "SELECT * FROM permohonan_sertifikasi WHERE status = 'approved' AND jenis_sertifikasi = 'perorangan' ORDER BY tanggal_pengajuan DESC";
$result = $conn->query($sql);
?>

<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Status Permohonan Sertifikasi</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- DataTables CSS -->
    <link href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap5.min.css" rel="stylesheet">
    <!-- FontAwesome untuk ikon -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
</head>

<body>

    <div class="container my-5">
        <!-- Filter Jenis Sertifikasi -->
        <div class="mb-4">
            <div class="row">
                <div class="col-auto">
                    <!-- <a href="validation.php" class="btn btn-outline-secondary">Semua</a> -->
                    <!-- <a href="validation_badan_usaha.php" class="btn btn-outline-primary">Badan Usaha</a>
                    <a href="validation_profesi.php" class="btn btn-info">Perorangan</a> -->
                </div>
            </div>
        </div>
        
        <!-- Tabel permohonan sertifikasi dengan border dan shadow -->
        <div class="table-responsive shadow-lg border rounded p-3 bg-white">
            <!-- <h2 class="text-center mb-4">Sertifikat Perorangan</h2> -->
            <table id="permohonanTable" class="table table-striped table-bordered">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>No Register</th>
                        <!-- <th>No HP</th>
                        <th>Email</th> -->
                        <th>Nama Pemohon</th>
                        <!-- <th>Nilai</th>
                        <th>Kriteria</th>
                        <th>Wilayah</th> -->
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    if ($result->num_rows > 0) {
                        $no = 1;
                        while ($row = $result->fetch_assoc()) {
                            // Tombol aksi untuk PDF
                            $actionButton = "<a href='sertifikat.php?no_reg=" . $row['no_reg'] . "' class='btn btn-danger btn-sm' target='_blank'>
                                              <i class='fas fa-file-pdf'></i></a>";

                            $nilai_display = $row['nilai'] ? number_format($row['nilai'], 2) . '%' : '-';
                            $kriteria_display = $row['jumlah_kriteria'] ? $row['jumlah_kriteria'] : '-';
                            
                            echo "<tr>
                                <td>" . $no++ . "</td>
                                <td>" . $row['no_reg'] . "</td>
                                <td>" . $row['nama_pemohon'] . "</td>
                                <td class='text-center'>" . $actionButton . "</td>
                            </tr>";
                        }
                    } else {
                        // Jika tidak ada data
                        echo "<tr><td colspan='9' class='text-center'>Tidak ada data ditemukan.</td></tr>";
                    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Bootstrap JS, jQuery dan DataTables JS -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>

    <script>
        $(document).ready(function () {
            // Menginisialisasi DataTables
            $('#permohonanTable').DataTable({
                "pageLength": 10,
                "order": [],
                "language": {
                    "search": "Pencarian:",
                    "lengthMenu": "Tampilkan _MENU_ data",
                    "zeroRecords": "Data tidak ditemukan",
                    "info": "Menampilkan halaman _PAGE_ dari _PAGES_",
                    "infoEmpty": "Tidak ada data yang tersedia",
                    "infoFiltered": "(difilter dari _MAX_ total data)",
                    "paginate": {
                        "first": "Pertama",
                        "last": "Terakhir",
                        "next": "Selanjutnya",
                        "previous": "Sebelumnya"
                    }
                }
            });
        });
    </script>

</body>

</html>