<?php
require('../fpdf.php');
include('../config/db.php');
require('qrcode.php');

if (isset($_GET['no_reg'])) {
    $no_reg = $_GET['no_reg'];

    // Ambil data dari database berdasarkan no_reg
    $sql = "SELECT * FROM permohonan_sertifikasi WHERE no_reg = '$no_reg' AND status = 'approved'";
    $result = $conn->query($sql);

    if ($result->num_rows > 0) {
        $data = $result->fetch_assoc();

        class PDF extends FPDF
        {
            private $jenis_sertifikasi;

            function __construct($orientation = 'P', $unit = 'mm', $size = 'A4', $jenis = 'badan_usaha')
            {
                parent::__construct($orientation, $unit, $size);
                $this->jenis_sertifikasi = $jenis;

                // Add custom fonts
                $this->AddFont('Poppins', '', 'Poppins-Regular.php');
                $this->AddFont('Poppins', 'B', 'Poppins-Bold.php');
                $this->AddFont('Poppins', 'I', 'Poppins-Italic.php');
                $this->AddFont('Poppins', 'BI', 'Poppins-BoldItalic.php');
            }

            function Header()
            {
                // Pilih background berdasarkan jenis sertifikasi
                if ($this->jenis_sertifikasi === 'badan_usaha') {
                    $bgPath = dirname(__DIR__) . '/assets/img/bg-badan-usaha.png';
                    // Fallback ke bg-asset.png jika bg-badan-usaha.png tidak ada
                    if (!file_exists($bgPath)) {
                        $bgPath = dirname(__DIR__) . '/assets/img/bg-asset.png';
                    }
                } elseif ($this->jenis_sertifikasi === 'perorangan') {
                    $bgPath = dirname(__DIR__) . '/assets/img/bg-perorangan.png';
                    // Fallback ke bg-asset.png jika bg-perorangan.png tidak ada
                    if (!file_exists($bgPath)) {
                        $bgPath = dirname(__DIR__) . '/assets/img/bg-asset.png';
                    }
                } else {
                    // Default background
                    $bgPath = dirname(__DIR__) . '/assets/img/bg-asset.png';
                }

                if (file_exists($bgPath)) {
                    $this->Image($bgPath, 0, 0, 210, 297); // Sesuaikan dengan ukuran A4
                } else {
                    die('Background tidak ditemukan: ' . $bgPath);
                }
            }
        }

        // Fungsi untuk format tanggal
        function formatTanggalIndonesia($tanggal)
        {
            $bulan = [
                1 => 'Januari',
                'Februari',
                'Maret',
                'April',
                'Mei',
                'Juni',
                'Juli',
                'Agustus',
                'September',
                'Oktober',
                'November',
                'Desember'
            ];
            $tanggalSplit = explode('-', $tanggal);
            return $tanggalSplit[2] . ' ' . $bulan[(int) $tanggalSplit[1]] . ' ' . $tanggalSplit[0];
        }

        $pdf = new PDF('P', 'mm', 'A4', $data['jenis_sertifikasi']);
        $pdf->AddPage();
        
        // Set margin bawah lebih kecil untuk memberikan ruang lebih
        $pdf->SetAutoPageBreak(false);

        // Generate QR Code
        $baseUrl = 'https://sistem-lamskk.local/public/sertifikat.php?no_reg=' . urlencode($data['no_reg']);
        $qrCode = new SimpleQRCode($baseUrl, 200);
        $qrTempFile = '../temp/qr_' . md5($data['no_reg']) . '.png';

        // Pastikan folder temp ada
        if (!is_dir('../temp')) {
            mkdir('../temp', 0755, true);
        }

        // Tampilkan data berdasarkan jenis sertifikasi
        if ($data['jenis_sertifikasi'] === 'perorangan') {
            // Data untuk Perorangan: Nomor, Nama, Tempat Tanggal Lahir, tanggal

            // Nomor
            $pdf->SetY(87);
            $pdf->SetFont('Times', '', 14);
            $pdf->Cell(0, 10, $data['no_reg'], 0, 1, 'C');

            // Nama
            $pdf->SetY(109);
            $pdf->SetX(88);
            $pdf->SetFont('Poppins', '', 14);
            $pdf->Cell(0, 10, $data['nama_pemohon'], 0, 1, 'L');

            // Tempat Tanggal Lahir
            if (!empty($data['tempat_lahir']) && !empty($data['tanggal_lahir'])) {
                $pdf->SetY(116);
                $pdf->SetX(88);
                $pdf->SetFont('Poppins', '', 14);
                $ttl = $data['tempat_lahir'] . ', ' . formatTanggalIndonesia($data['tanggal_lahir']);
                $pdf->Cell(0, 10, $ttl, 0, 1, 'L');
            }

            // Nama Perusahaan
            if (!empty($data['nama_perusahaan'])) {
                $pdf->SetY(122.5);
                $pdf->SetX(88);
                $pdf->SetFont('Poppins', '', 14);
                $pdf->Cell(0, 10, $data['nama_perusahaan'], 0, 1, 'L');
            }

            // Tanggal
            $pdf->SetY(213);
            $pdf->SetX(115);
            $pdf->SetFont('Times', '', 10);
            $tanggal = formatTanggalIndonesia(date('Y-m-d', strtotime($data['tanggal_pengajuan'])));
            $pdf->Cell(0, 10, $tanggal, 0, 1, 'C');

            // Generate dan save QR code
            if ($qrCode->saveQR($qrTempFile)) {
                if (file_exists($qrTempFile)) {
                    $pdf->Image($qrTempFile, 30, 250, 20, 20);
                    unlink($qrTempFile);
                }
            }
        } else {
            // Data untuk Badan Usaha: no pasal, tahun pasal, nama perusahaan, alamat, nilai, jumlah kriteria, tanggal

            // No Pasal
            $pdf->SetY(118);
            $pdf->SetX(67);
            $pdf->SetFont('Times', '', 16);
            $pdf->Cell(0, 10, $data['no_pasal'] ?? $data['no_reg'], 0, 1, 'C');

            // Tahun Pasal
            if (!empty($data['tahun_pasal'])) {
                $pdf->SetY(118);
                $pdf->SetX(123);
                $pdf->SetFont('Times', '', 16);
                $pdf->Cell(0, 10, $data['tahun_pasal'], 0, 1, 'C');
            }

            // Nama Perusahaan
            $pdf->SetY(150);
            $pdf->SetFont('Poppins', 'B', 20);
            $pdf->Cell(0, 10, $data['nama_perusahaan'], 0, 1, 'C');

            // Sektor - ID normal, EN italic
            $pdf->SetY(190);
            $pdf->SetFont('Poppins', 'B', 20);
            
            // Hitung posisi untuk centering
            $sektor_text = $data['sektor_id'] . " / " . $data['sektor_en'];
            $text_width = $pdf->GetStringWidth($sektor_text);
            $x_start = (210 - $text_width) / 2; // 210 adalah lebar halaman A4
            
            // Tulis sektor Indonesia (normal)
            $pdf->SetX($x_start);
            $pdf->Cell($pdf->GetStringWidth($data['sektor_id']), 10, $data['sektor_id'], 0, 0, 'L');
            
            // Tulis " / "
            $pdf->Cell($pdf->GetStringWidth(' / '), 10, ' / ', 0, 0, 'L');
            
            // Tulis sektor English (Poppins Bold Italic)
            $pdf->SetFont('Poppins', 'BI', 20);
            $pdf->Cell($pdf->GetStringWidth($data['sektor_en']), 10, $data['sektor_en'], 0, 1, 'L');

            // Alamat
            if (!empty($data['alamat'])) {
                $pdf->SetY(175);
                $pdf->SetFont('Poppins', '', 20);
                $pdf->Cell(0, 10, $data['alamat'], 0, 1, 'C');
            }

            if (!empty($data['alamat'])) {
                $pdf->SetY(175);
                $pdf->SetFont('Poppins', '', 20);
                $pdf->Cell(0, 10, $data['alamat'], 0, 1, 'C');
            }

            // Nilai
            if (!empty($data['nilai'])) {
                $pdf->SetY(212);
                $pdf->SetX(88);
                $pdf->SetFont('Poppins', '', 12);
                $pdf->Cell(0, 10, number_format($data['nilai'], 2) . '%', 0, 1, 'L');
            }

            // Jumlah Kriteria
            if (!empty($data['jumlah_kriteria'])) {
                $pdf->SetY(212);
                $pdf->SetX(92);
                $pdf->SetFont('Poppins', '', 12);
                $pdf->Cell(0, 10, '( ' .$data['jumlah_kriteria']. ' )', 0, 1, 'C');
            }
            // BHS INgris
            // Nilai
            if (!empty($data['nilai'])) {
                $pdf->SetY(217.5);
                $pdf->SetX(81);
                $pdf->SetFont('Poppins', 'I', 12);
                $pdf->Cell(0, 10, number_format($data['nilai'], 2) . '%', 0, 1, 'L');
            }

            if (!empty($data['jumlah_kriteria'])) {
                $pdf->SetY(217.5);
                $pdf->SetX(77);
                $pdf->SetFont('Poppins', 'I', 12);
                $pdf->Cell(0, 10, '( ' .$data['jumlah_kriteria']. ' )', 0, 1, 'C');
            }

            // Tahun Berlaku
            if (!empty($data['nilai'])) {
                $pdf->SetY(217.5);
                $pdf->SetX(81);
                $pdf->SetFont('Poppins', 'I', 12);
                $pdf->Cell(0, 10, number_format($data['nilai'], 2) . '%', 0, 1, 'L');
            }

            // Tahun
            if (!empty($data['tahun_id'])) {
                $pdf->SetY(226);
                $pdf->SetX(48);
                $pdf->SetFont('Poppins', '', 13);
                $pdf->Cell(0, 10, $data['tahun_id'], 0, 1, 'C');
            }

            // Tahun
            if (!empty($data['tahun_en'])) {
                $pdf->SetY(231.5);
                $pdf->SetX(0);
                $pdf->SetFont('Poppins', '', 13);
                $pdf->Cell(0, 10, $data['tahun_id'], 0, 1, 'C');
            }

            // Tanggal
            $pdf->SetY(241.5);
            $pdf->SetX(154);
            $pdf->SetFont('Times', '', 13);
            $tanggal = formatTanggalIndonesia(date('Y-m-d', strtotime($data['tanggal_pengajuan'])));
            $pdf->Cell(0, 10, $tanggal, 0, 1, 'C');
            
            // Direktur - bisa 2 baris jika nama panjang
            if (!empty($data['nama_direktur'])) {
                $pdf->SetFont('Poppins', '', 9);
                
                // Hitung lebar teks untuk menentukan apakah perlu dibagi 2 baris
                $nama_width = $pdf->GetStringWidth($data['nama_direktur']);
                $max_width = 110; // Maksimal lebar untuk 1 baris (dalam mm)
                
                if ($nama_width > $max_width) {
                    // Bagi nama menjadi 2 baris
                    $words = explode(' ', $data['nama_direktur']);
                    $line1 = '';
                    $line2 = '';
                    $mid = ceil(count($words) / 2);
                    
                    for ($i = 0; $i < $mid; $i++) {
                        $line1 .= $words[$i] . ' ';
                    }
                    for ($i = $mid; $i < count($words); $i++) {
                        $line2 .= $words[$i] . ' ';
                    }
                    
                    // Baris pertama - posisi lebih ke bawah
                    $pdf->SetY(275);
                    $pdf->SetX(128);
                    $pdf->Cell(0, 4, trim($line1), 0, 1, 'C');
                    
                    // Baris kedua
                    $pdf->SetY(279);
                    $pdf->SetX(128);
                    $pdf->Cell(0, 4, trim($line2), 0, 1, 'C');
                } else {
                    // Nama pendek, 1 baris saja - posisi lebih ke bawah
                    $pdf->SetY(277);
                    $pdf->SetX(128);
                    $pdf->Cell(0, 4, $data['nama_direktur'], 0, 1, 'C');
                }
            }

            // Generate dan save QR code - posisi sedikit lebih atas
            if ($qrCode->saveQR($qrTempFile)) {
                if (file_exists($qrTempFile)) {
                    $pdf->Image($qrTempFile, 50, 270, 20, 20);
                    unlink($qrTempFile);
                }
            }
        }

        // Tentukan nama file berdasarkan jenis sertifikasi
        $jenis_label = $data['jenis_sertifikasi'] === 'perorangan' ? 'Perorangan' : 'BadanUsaha';
        $filename = 'Sertifikat_' . $jenis_label . '_' . $data['no_reg'] . '.pdf';

        // Output PDF
        header('Content-Type: application/pdf');
        $pdf->Output('I', $filename);
    } else {
        echo "Data tidak ditemukan atau tidak disetujui.";
    }
} else {
    echo "No. Registrasi tidak ditemukan.";
}
