<?php
// Koneksi database
require_once('../config/db.php');

// Initialize variables
$error = [];
$success = false;

// Check if form is submitted
if (isset($_POST['submit'])) {
    // Validate required fields
    $required_fields = [
        'no_reg' => 'No Reg',
        'nama_pemohon' => 'Nama Pemohon',
        'no_hp' => 'No HP Pemohon',
        'email' => 'Email Pemohon',
        'nama_perusahaan' => 'Nama Perusahaan',
        'nama_penghargaan' => 'Nama Penghargaan',
        'jenis_sertifikasi' => 'Jenis Sertifikasi',
        'wilayah' => 'Wilayah',
        'tanggal_pengajuan' => 'Tanggal Pengajuan'
    ];

    foreach ($required_fields as $field => $label) {
        if (empty($_POST[$field])) {
            $error[] = "$label wajib diisi";
        }
    }

    // Validate email format
    if (!empty($_POST['email']) && !filter_var($_POST['email'], FILTER_VALIDATE_EMAIL)) {
        $error[] = "Format email tidak valid";
    }

    // Process form if no errors
    if (empty($error)) {
        // Escape strings untuk mencegah SQL injection
        $no_reg = mysqli_real_escape_string($conn, $_POST['no_reg']);
        $nama_pemohon = mysqli_real_escape_string($conn, $_POST['nama_pemohon']);
        $no_hp = mysqli_real_escape_string($conn, $_POST['no_hp']);
        $email = mysqli_real_escape_string($conn, $_POST['email']);
        $nama_perusahaan = mysqli_real_escape_string($conn, $_POST['nama_perusahaan']);
        $nama_penghargaan = mysqli_real_escape_string($conn, $_POST['nama_penghargaan']);
        $jenis_sertifikasi = mysqli_real_escape_string($conn, $_POST['jenis_sertifikasi']);
        $wilayah = mysqli_real_escape_string($conn, $_POST['wilayah']);
        $tanggal_pengajuan = mysqli_real_escape_string($conn, $_POST['tanggal_pengajuan']);

        // Query insert ke database
        $query = "INSERT INTO permohonan_sertifikasi 
                 (no_reg, nama_pemohon, no_hp, email, nama_perusahaan, nama_penghargaan, jenis_sertifikasi, wilayah, tanggal_pengajuan) 
                 VALUES 
                 ('$no_reg', '$nama_pemohon', '$no_hp', '$email', '$nama_perusahaan', '$nama_penghargaan', '$jenis_sertifikasi', '$wilayah', '$tanggal_pengajuan')";

        if (mysqli_query($conn, $query)) {
            $success = true;
        } else {
            $error[] = "Error: " . mysqli_error($conn);
        }
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Registrasi Rekor</title>
    <!-- Bootstrap CDN -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
</head>
<body class="bg-light">
    <div class="container my-5">
        <div class="row justify-content-center">
            <!-- Kolom form diatur untuk 6/12 lebar layar pada medium ke atas, 12/12 pada layar kecil -->
            <div class="col-md-8 col-12">
                <div class="p-4 shadow-sm bg-white rounded">
                    <h2 class="text-center mb-4">Registrasi Rekor</h2>

                    <?php
                    // Show error messages if any
                    if (!empty($error)): ?>
                        <div class="alert alert-danger">
                            <?php foreach($error as $err): ?>
                                <div><?php echo htmlspecialchars($err); ?></div>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>

                    <?php 
                    // Show success message only after successful submission
                    if (isset($_POST['submit']) && $success): ?>
                        <div class="alert alert-success">Registration submitted successfully!</div>
                    <?php endif; ?>

                    <form method="POST">
                        <div class="mb-3">
                            <label for="no_reg" class="form-label">No Reg <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="no_reg" name="no_reg" required>
                        </div>

                        <div class="mb-3">
                            <label for="nama_pemohon" class="form-label">Nama Pemohon <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="nama_pemohon" name="nama_pemohon" required>
                        </div>

                        <div class="mb-3">
                            <label for="no_hp" class="form-label">No HP Pemohon <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="no_hp" name="no_hp" required>
                        </div>

                        <div class="mb-3">
                            <label for="email" class="form-label">Email Pemohon <span class="text-danger">*</span></label>
                            <input type="email" class="form-control" id="email" name="email" required>
                        </div>

                        <div class="mb-3">
                            <label for="nama_perusahaan" class="form-label">Nama Perusahaan <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="nama_perusahaan" name="nama_perusahaan" required>
                        </div>

                        <div class="mb-3">
                            <label for="nama_penghargaan" class="form-label">Nama Penghargaan <span class="text-danger">*</span></label>
                            <textarea class="form-control" id="nama_penghargaan" name="nama_penghargaan" required rows="4"></textarea>
                        </div>

                        <div class="mb-3">
                            <label for="jenis_sertifikasi" class="form-label">Jenis Sertifikasi <span class="text-danger">*</span></label>
                            <select class="form-control" id="jenis_sertifikasi" name="jenis_sertifikasi" required>
                                <option value="">Pilih Jenis Sertifikasi</option>
                                <option value="badan_usaha">Untuk Badan Usaha</option>
                                <option value="profesi">Untuk Profesi</option>
                            </select>
                        </div>

                        <div class="mb-3">
                            <label for="wilayah" class="form-label">Wilayah <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="wilayah" name="wilayah" required>
                        </div>

                        <div class="mb-3">
                            <label for="tanggal_pengajuan" class="form-label">Tanggal Pengajuan <span class="text-danger">*</span></label>
                            <input type="date" class="form-control" id="tanggal_pengajuan" name="tanggal_pengajuan" value="<?php echo date('Y-m-d'); ?>" required>
                        </div>

                        <button type="submit" name="submit" class="btn btn-primary w-100">Kirim</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous"></script>
</body>
</html>
