-- Update database schema untuk mendukung form perorangan dan badan usaha terpisah

-- 1. Update ENUM untuk jenis_sertifikasi dari 'profesi' menjadi 'perorangan'
ALTER TABLE `permohonan_sertifikasi` 
MODIFY COLUMN `jenis_sertifikasi` ENUM('badan_usaha', 'perorangan') NOT NULL DEFAULT 'badan_usaha';

-- Update data existing yang menggunakan 'profesi' menjadi 'perorangan'
-- Pertama tambah 'perorangan' ke ENUM existing
ALTER TABLE `permohonan_sertifikasi` 
MODIFY COLUMN `jenis_sertifikasi` ENUM('badan_usaha', 'profesi', 'perorangan') NOT NULL DEFAULT 'badan_usaha';

-- Update data yang menggunakan 'profesi' menjadi 'perorangan'
UPDATE `permohonan_sertifikasi` 
SET `jenis_sertifikasi` = 'perorangan' 
WHERE `jenis_sertifikasi` = 'profesi';

-- Hapus 'profesi' dari ENUM
ALTER TABLE `permohonan_sertifikasi` 
MODIFY COLUMN `jenis_sertifikasi` ENUM('badan_usaha', 'perorangan') NOT NULL DEFAULT 'badan_usaha';

-- 2. Tambah field untuk perorangan
ALTER TABLE `permohonan_sertifikasi` 
ADD COLUMN `tempat_lahir` VARCHAR(100) NULL COMMENT 'Tempat lahir untuk perorangan' 
AFTER `nama_pemohon`;

ALTER TABLE `permohonan_sertifikasi` 
ADD COLUMN `tanggal_lahir` DATE NULL COMMENT 'Tanggal lahir untuk perorangan' 
AFTER `tempat_lahir`;

-- 3. Tambah field untuk badan usaha
ALTER TABLE `permohonan_sertifikasi` 
ADD COLUMN `no_pasal` VARCHAR(50) NULL COMMENT 'Nomor pasal untuk badan usaha' 
AFTER `no_reg`;

ALTER TABLE `permohonan_sertifikasi` 
ADD COLUMN `tahun_pasal` YEAR NULL COMMENT 'Tahun pasal untuk badan usaha' 
AFTER `no_pasal`;

ALTER TABLE `permohonan_sertifikasi` 
ADD COLUMN `alamat` TEXT NULL COMMENT 'Alamat perusahaan untuk badan usaha' 
AFTER `nama_perusahaan`;

-- 4. Modifikasi field yang sudah ada agar bisa NULL untuk perorangan
ALTER TABLE `permohonan_sertifikasi` 
MODIFY COLUMN `nama_perusahaan` VARCHAR(255) NULL;

ALTER TABLE `permohonan_sertifikasi` 
MODIFY COLUMN `no_hp` VARCHAR(20) NULL;

ALTER TABLE `permohonan_sertifikasi` 
MODIFY COLUMN `email` VARCHAR(100) NULL;

-- 5. Tambah index untuk performa
CREATE INDEX idx_jenis_sertifikasi ON permohonan_sertifikasi(jenis_sertifikasi);
CREATE INDEX idx_status ON permohonan_sertifikasi(status);
CREATE INDEX idx_tanggal_pengajuan ON permohonan_sertifikasi(tanggal_pengajuan);