<?php
session_start();

if (!isset($_SESSION['admin_logged_in'])) {
    header('Location: login.php');
    exit();
}

require_once('../config/db.php');

$error = [];
$success = false;

if (isset($_POST['submit'])) {
    $required_fields = [
        'nomor' => 'Nomor',
        'nama' => 'Nama',
        'nama_perusahaan' => 'Nama Perusahaan',
        'tempat_lahir' => 'Tempat Lahir',
        'tanggal_lahir' => 'Tanggal Lahir',
        'tanggal' => 'Tanggal'
    ];

    foreach ($required_fields as $field => $label) {
        if (empty($_POST[$field])) {
            $error[] = "$label wajib diisi";
        }
    }

    if (empty($error)) {
        $nomor = mysqli_real_escape_string($conn, $_POST['nomor']);
        $nama = mysqli_real_escape_string($conn, $_POST['nama']);
        $nama_perusahaan = mysqli_real_escape_string($conn, $_POST['nama_perusahaan']);
        $tempat_lahir = mysqli_real_escape_string($conn, $_POST['tempat_lahir']);
        $tanggal_lahir = mysqli_real_escape_string($conn, $_POST['tanggal_lahir']);
        $tanggal = mysqli_real_escape_string($conn, $_POST['tanggal']);

        $query = "INSERT INTO permohonan_sertifikasi 
                 (no_reg, nama_pemohon, nama_perusahaan, tempat_lahir, tanggal_lahir, jenis_sertifikasi, status, tanggal_pengajuan) 
                 VALUES 
                 ('$nomor', '$nama', '$nama_perusahaan', '$tempat_lahir', '$tanggal_lahir', 'perorangan', 'approved', '$tanggal')";

        if (mysqli_query($conn, $query)) {
            $success = true;
        } else {
            $error[] = "Error: " . mysqli_error($conn);
        }
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tambah Permohonan Perorangan</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
</head>

<body>
    <?php include 'sidebar.php'; ?>

    <div class="container-fluid">
        <div class="row">
            <main class="col-md-9 ms-sm-auto col-lg-10 px-5 mt-4">
                <div class="d-flex justify-content-between align-items-center pb-3 mb-4 border-bottom">
                    <h2>Tambah Permohonan Sertifikasi Perorangan</h2>
                </div>

                <?php if (!empty($error)): ?>
                    <div class="alert alert-danger alert-dismissible fade show mb-4" role="alert">
                        <i class="fas fa-exclamation-circle me-2"></i>
                        <?php foreach($error as $err): ?>
                            <div><?php echo htmlspecialchars($err); ?></div>
                        <?php endforeach; ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                <?php endif; ?>

                <?php if (isset($_POST['submit']) && $success): ?>
                    <div class="alert alert-success alert-dismissible fade show mb-4" role="alert">
                        <i class="fas fa-check-circle me-2"></i>Permohonan berhasil ditambahkan!
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                <?php endif; ?>

                <div class="row justify-content-center">
                    <div class="col-lg-8">
                        <div class="card shadow">
                            <div class="card-header bg-success text-white">
                                <h5 class="card-title mb-0">
                                    <i class="fas fa-user me-2"></i>Form Permohonan Perorangan
                                </h5>
                            </div>
                            <div class="card-body p-4">
                                <form method="POST">
                                    <div class="mb-3">
                                        <label for="nomor" class="form-label">Nomor <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" id="nomor" name="nomor" required 
                                               placeholder="Contoh: No.0001/R.IBR/I/2025">
                                    </div>

                                    <div class="mb-3">
                                        <label for="nama" class="form-label">Nama <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" id="nama" name="nama" required>
                                    </div>

                                    <div class="mb-3">
                                        <label for="nama_perusahaan" class="form-label">Nama Perusahaan <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" id="nama_perusahaan" name="nama_perusahaan" required>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-6 mb-3">
                                            <label for="tempat_lahir" class="form-label">Tempat Lahir <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control" id="tempat_lahir" name="tempat_lahir" required 
                                                   placeholder="Contoh: Jakarta">
                                        </div>

                                        <div class="col-md-6 mb-3">
                                            <label for="tanggal_lahir" class="form-label">Tanggal Lahir <span class="text-danger">*</span></label>
                                            <input type="date" class="form-control" id="tanggal_lahir" name="tanggal_lahir" required>
                                        </div>
                                    </div>

                                    <div class="mb-4">
                                        <label for="tanggal" class="form-label">Tanggal <span class="text-danger">*</span></label>
                                        <input type="date" class="form-control" id="tanggal" name="tanggal" 
                                               value="<?php echo date('Y-m-d'); ?>" required>
                                    </div>

                                    <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                                        <a href="index.php" class="btn btn-secondary me-md-2">
                                            <i class="fas fa-arrow-left me-1"></i>Kembali
                                        </a>
                                        <button type="reset" class="btn btn-outline-secondary me-md-2">
                                            <i class="fas fa-undo me-1"></i>Reset
                                        </button>
                                        <button type="submit" name="submit" class="btn btn-success">
                                            <i class="fas fa-save me-1"></i>Simpan Permohonan
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </main>
        </div>
    </div>
</body>
</html>
<?php mysqli_close($conn); ?>