<?php
session_start();

// Security check - Ensure only logged in admins can access
if (!isset($_SESSION['admin_logged_in'])) {
    header('Location: login.php');
    exit();
}

// Database connection configuration
require_once('../config/db.php');

// Initialize variables
$error = [];
$success = false;

// Check if form is submitted
if (isset($_POST['submit'])) {
    // Validate required fields
    $required_fields = [
        'no_reg' => 'No Reg',
        'nama_pemohon' => 'Nama Pemohon',
        'no_hp' => 'No HP Pemohon',
        'email' => 'Email Pemohon',
        'nama_perusahaan' => 'Nama Perusahaan',
        'nilai' => 'Nilai',
        'jumlah_kriteria' => 'Jumlah Kriteria',
        'jenis_sertifikasi' => 'Jenis Sertifikasi',
        'wilayah' => 'Wilayah',
        'tanggal_pengajuan' => 'Tanggal Pengajuan'
    ];

    foreach ($required_fields as $field => $label) {
        if (empty($_POST[$field])) {
            $error[] = "$label wajib diisi";
        }
    }

    // Validate email format
    if (!empty($_POST['email']) && !filter_var($_POST['email'], FILTER_VALIDATE_EMAIL)) {
        $error[] = "Format email tidak valid";
    }

    // Validate nilai (percentage)
    if (!empty($_POST['nilai'])) {
        $nilai_input = (float) $_POST['nilai'];
        if ($nilai_input < 0 || $nilai_input > 100) {
            $error[] = "Nilai harus antara 0 dan 100";
        }
    }

    // Validate jumlah_kriteria (positive integer)
    if (!empty($_POST['jumlah_kriteria'])) {
        $jumlah_kriteria_input = (int) $_POST['jumlah_kriteria'];
        if ($jumlah_kriteria_input <= 0) {
            $error[] = "Jumlah kriteria harus lebih dari 0";
        }
    }

    // Process form if no errors
    if (empty($error)) {
        // Escape strings untuk mencegah SQL injection
        $no_reg = mysqli_real_escape_string($conn, $_POST['no_reg']);
        $nama_pemohon = mysqli_real_escape_string($conn, $_POST['nama_pemohon']);
        $no_hp = mysqli_real_escape_string($conn, $_POST['no_hp']);
        $email = mysqli_real_escape_string($conn, $_POST['email']);
        $nama_perusahaan = mysqli_real_escape_string($conn, $_POST['nama_perusahaan']);
        $nilai = (float) $_POST['nilai'];
        $jumlah_kriteria = (int) $_POST['jumlah_kriteria'];
        $jenis_sertifikasi = mysqli_real_escape_string($conn, $_POST['jenis_sertifikasi']);
        $wilayah = mysqli_real_escape_string($conn, $_POST['wilayah']);
        $tanggal_pengajuan = mysqli_real_escape_string($conn, $_POST['tanggal_pengajuan']);

        // Query insert ke database
        $query = "INSERT INTO permohonan_sertifikasi 
                 (no_reg, nama_pemohon, no_hp, email, nama_perusahaan, nilai, jumlah_kriteria, jenis_sertifikasi, wilayah, status, tanggal_pengajuan) 
                 VALUES 
                 ('$no_reg', '$nama_pemohon', '$no_hp', '$email', '$nama_perusahaan', '$nilai', '$jumlah_kriteria', '$jenis_sertifikasi', '$wilayah', 'approved', '$tanggal_pengajuan')";

        if (mysqli_query($conn, $query)) {
            $success = true;
        } else {
            $error[] = "Error: " . mysqli_error($conn);
        }
    }
}
?>

<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tambah Permohonan Sertifikasi</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
</head>

<body>
    <?php include 'sidebar.php'; ?>

    <div class="container-fluid">
        <div class="row">
            <main class="col-md-9 ms-sm-auto col-lg-10 px-5 mt-4">
                <div class="d-flex justify-content-between align-items-center pb-3 mb-4 border-bottom">
                    <h2>Tambah Permohonan Sertifikasi</h2>
                </div>

                <!-- Display success/error messages -->
                <?php if (!empty($error)): ?>
                    <div class="alert alert-danger alert-dismissible fade show mb-4" role="alert">
                        <i class="fas fa-exclamation-circle me-2"></i>
                        <?php foreach($error as $err): ?>
                            <div><?php echo htmlspecialchars($err); ?></div>
                        <?php endforeach; ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                <?php endif; ?>

                <?php if (isset($_POST['submit']) && $success): ?>
                    <div class="alert alert-success alert-dismissible fade show mb-4" role="alert">
                        <i class="fas fa-check-circle me-2"></i>Permohonan berhasil ditambahkan!
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                <?php endif; ?>

                <!-- Form Container -->
                <div class="row justify-content-center">
                    <div class="col-lg-8">
                        <div class="card shadow">
                            <div class="card-header bg-primary text-white">
                                <h5 class="card-title mb-0">
                                    <i class="fas fa-plus-circle me-2"></i>Form Permohonan Sertifikasi
                                </h5>
                            </div>
                            <div class="card-body p-4">
                                <form method="POST">
                                    <div class="row">
                                        <div class="col-md-6 mb-3">
                                            <label for="no_reg" class="form-label">No Reg <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control" id="no_reg" name="no_reg" required>
                                        </div>

                                        <div class="col-md-6 mb-3">
                                            <label for="nama_pemohon" class="form-label">Nama Pemohon <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control" id="nama_pemohon" name="nama_pemohon" required>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-6 mb-3">
                                            <label for="no_hp" class="form-label">No HP Pemohon <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control" id="no_hp" name="no_hp" required>
                                        </div>

                                        <div class="col-md-6 mb-3">
                                            <label for="email" class="form-label">Email Pemohon <span class="text-danger">*</span></label>
                                            <input type="email" class="form-control" id="email" name="email" required>
                                        </div>
                                    </div>

                                    <div class="mb-3">
                                        <label for="nama_perusahaan" class="form-label">Nama Perusahaan <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" id="nama_perusahaan" name="nama_perusahaan" required>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-6 mb-3">
                                            <label for="nilai" class="form-label">Nilai (%) <span class="text-danger">*</span></label>
                                            <div class="input-group">
                                                <input type="number" class="form-control" id="nilai" name="nilai" required step="0.01" min="0" max="100" placeholder="89.54">
                                                <span class="input-group-text">%</span>
                                            </div>
                                            <div class="form-text">Contoh: 89.54</div>
                                        </div>

                                        <div class="col-md-6 mb-3">
                                            <label for="jumlah_kriteria" class="form-label">Jumlah Kriteria <span class="text-danger">*</span></label>
                                            <input type="number" class="form-control" id="jumlah_kriteria" name="jumlah_kriteria" required min="1" placeholder="86">
                                            <div class="form-text">Contoh: 86</div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-6 mb-3">
                                            <label for="jenis_sertifikasi" class="form-label">Jenis Sertifikasi <span class="text-danger">*</span></label>
                                            <select class="form-select" id="jenis_sertifikasi" name="jenis_sertifikasi" required>
                                                <option value="">Pilih Jenis Sertifikasi</option>
                                                <option value="badan_usaha">Untuk Badan Usaha</option>
                                                <option value="perorangan">Untuk Perorangan</option>
                                            </select>
                                        </div>

                                        <div class="col-md-6 mb-3">
                                            <label for="wilayah" class="form-label">Wilayah <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control" id="wilayah" name="wilayah" required>
                                        </div>
                                    </div>

                                    <div class="mb-4">
                                        <label for="tanggal_pengajuan" class="form-label">Tanggal Pengajuan <span class="text-danger">*</span></label>
                                        <input type="date" class="form-control" id="tanggal_pengajuan" name="tanggal_pengajuan" value="<?php echo date('Y-m-d'); ?>" required>
                                    </div>

                                    <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                                        <button type="reset" class="btn btn-secondary me-md-2">
                                            <i class="fas fa-undo me-1"></i>Reset
                                        </button>
                                        <button type="submit" name="submit" class="btn btn-primary">
                                            <i class="fas fa-save me-1"></i>Simpan Permohonan
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </main>
        </div>
    </div>
</body>

</html>
<?php mysqli_close($conn); ?>