<?php
session_start();

if (!isset($_SESSION['admin_logged_in'])) {
    header('Location: login.php');
    exit();
}

require_once('../config/db.php');

$error = [];
$success = false;

if (isset($_POST['submit'])) {
    $required_fields = [
        'no_pasal' => 'No Pasal',
        'tahun_pasal' => 'Tahun Pasal',
        'nama_perusahaan' => 'Nama Perusahaan',
        'nama_direktur' => 'Nama Direktur',
        'sektor_id' => 'Sektor (Bahasa Indonesia)',
        'sektor_en' => 'Sektor (Bahasa Inggris)',
        'tahun_berlaku' => 'Tahun Berlaku',
        'alamat' => 'Alamat',
        'nilai' => 'Nilai',
        'jumlah_kriteria' => 'Jumlah Kriteria',
        'tanggal' => 'Tanggal'
    ];

    foreach ($required_fields as $field => $label) {
        if (empty($_POST[$field])) {
            $error[] = "$label wajib diisi";
        }
    }

    if (!empty($_POST['nilai'])) {
        $nilai_input = (float) $_POST['nilai'];
        if ($nilai_input < 0 || $nilai_input > 100) {
            $error[] = "Nilai harus antara 0 dan 100";
        }
    }

    if (!empty($_POST['jumlah_kriteria'])) {
        $jumlah_kriteria_input = (int) $_POST['jumlah_kriteria'];
        if ($jumlah_kriteria_input <= 0) {
            $error[] = "Jumlah kriteria harus lebih dari 0";
        }
    }

    if (empty($error)) {
        $no_pasal = mysqli_real_escape_string($conn, $_POST['no_pasal']);
        $tahun_pasal = mysqli_real_escape_string($conn, $_POST['tahun_pasal']);
        $nama_perusahaan = mysqli_real_escape_string($conn, $_POST['nama_perusahaan']);
        $nama_direktur = mysqli_real_escape_string($conn, $_POST['nama_direktur']);
        $sektor_id = mysqli_real_escape_string($conn, $_POST['sektor_id']);
        $sektor_en = mysqli_real_escape_string($conn, $_POST['sektor_en']);
        $tahun_berlaku = (int) $_POST['tahun_berlaku'];
        $alamat = mysqli_real_escape_string($conn, $_POST['alamat']);
        $nilai = (float) $_POST['nilai'];
        $jumlah_kriteria = (int) $_POST['jumlah_kriteria'];
        $tanggal = mysqli_real_escape_string($conn, $_POST['tanggal']);
        
        // Format tahun dalam bahasa Indonesia dan Inggris
        $tahun_terbilang = [
            1 => ['id' => '1 (Satu)', 'en' => '1 (One)'],
            2 => ['id' => '2 (Dua)', 'en' => '2 (Two)'],
            3 => ['id' => '3 (Tiga)', 'en' => '3 (Three)'],
            4 => ['id' => '4 (Empat)', 'en' => '4 (Four)'],
            5 => ['id' => '5 (Lima)', 'en' => '5 (Five)'],
            6 => ['id' => '6 (Enam)', 'en' => '6 (Six)'],
            7 => ['id' => '7 (Tujuh)', 'en' => '7 (Seven)'],
            8 => ['id' => '8 (Delapan)', 'en' => '8 (Eight)'],
            9 => ['id' => '9 (Sembilan)', 'en' => '9 (Nine)'],
            10 => ['id' => '10 (Sepuluh)', 'en' => '10 (Ten)'],
            11 => ['id' => '11 (Sebelas)', 'en' => '11 (Eleven)'],
            12 => ['id' => '12 (Dua Belas)', 'en' => '12 (Twelve)'],
            13 => ['id' => '13 (Tiga Belas)', 'en' => '13 (Thirteen)'],
            14 => ['id' => '14 (Empat Belas)', 'en' => '14 (Fourteen)'],
            15 => ['id' => '15 (Lima Belas)', 'en' => '15 (Fifteen)'],
            16 => ['id' => '16 (Enam Belas)', 'en' => '16 (Sixteen)'],
            17 => ['id' => '17 (Tujuh Belas)', 'en' => '17 (Seventeen)'],
            18 => ['id' => '18 (Delapan Belas)', 'en' => '18 (Eighteen)'],
            19 => ['id' => '19 (Sembilan Belas)', 'en' => '19 (Nineteen)'],
            20 => ['id' => '20 (Dua Puluh)', 'en' => '20 (Twenty)']
        ];
        
        $tahun_id = $tahun_terbilang[$tahun_berlaku]['id'];
        $tahun_en = $tahun_terbilang[$tahun_berlaku]['en'];

        $no_reg = bin2hex(random_bytes(16));

        $query = "INSERT INTO permohonan_sertifikasi 
                 (no_reg, nama_perusahaan, nama_direktur, sektor_id, sektor_en, tahun_id, tahun_en, alamat, nilai, jumlah_kriteria, jenis_sertifikasi, status, tanggal_pengajuan, no_pasal, tahun_pasal) 
                 VALUES 
                 ('$no_reg', '$nama_perusahaan', '$nama_direktur', '$sektor_id', '$sektor_en', '$tahun_id', '$tahun_en', '$alamat', '$nilai', '$jumlah_kriteria', 'badan_usaha', 'approved', '$tanggal', '$no_pasal', '$tahun_pasal')";

        if (mysqli_query($conn, $query)) {
            $success = true;
        } else {
            $error[] = "Error: " . mysqli_error($conn);
        }
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tambah Permohonan Badan Usaha</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
</head>

<body>
    <?php include 'sidebar.php'; ?>

    <div class="container-fluid">
        <div class="row">
            <main class="col-md-9 ms-sm-auto col-lg-10 px-5 mt-4">
                <div class="d-flex justify-content-between align-items-center pb-3 mb-4 border-bottom">
                    <h2>Tambah Permohonan Sertifikasi Badan Usaha</h2>
                </div>

                <?php if (!empty($error)): ?>
                    <div class="alert alert-danger alert-dismissible fade show mb-4" role="alert">
                        <i class="fas fa-exclamation-circle me-2"></i>
                        <?php foreach($error as $err): ?>
                            <div><?php echo htmlspecialchars($err); ?></div>
                        <?php endforeach; ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                <?php endif; ?>

                <?php if (isset($_POST['submit']) && $success): ?>
                    <div class="alert alert-success alert-dismissible fade show mb-4" role="alert">
                        <i class="fas fa-check-circle me-2"></i>Permohonan berhasil ditambahkan!
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                <?php endif; ?>

                <div class="row justify-content-center">
                    <div class="col-lg-8">
                        <div class="card shadow">
                            <div class="card-header bg-primary text-white">
                                <h5 class="card-title mb-0">
                                    <i class="fas fa-building me-2"></i>Form Permohonan Badan Usaha
                                </h5>
                            </div>
                            <div class="card-body p-4">
                                <form method="POST">
                                    <div class="row">
                                        <div class="col-md-6 mb-3">
                                            <label for="no_pasal" class="form-label">No Pasal <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control" id="no_pasal" name="no_pasal" required 
                                                   placeholder="Contoh: 20">
                                        </div>

                                        <div class="col-md-6 mb-3">
                                            <label for="tahun_pasal" class="form-label">Tahun Pasal <span class="text-danger">*</span></label>
                                            <input type="number" class="form-control" id="tahun_pasal" name="tahun_pasal" required 
                                                   min="1900" max="2099" value="<?php echo date('Y'); ?>">
                                        </div>
                                    </div>

                                    <div class="mb-3">
                                        <label for="nama_perusahaan" class="form-label">Nama Perusahaan <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" id="nama_perusahaan" name="nama_perusahaan" required>
                                    </div>

                                    <div class="mb-3">
                                        <label for="nama_direktur" class="form-label">Nama Direktur <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" id="nama_direktur" name="nama_direktur" required 
                                               placeholder="Masukkan nama direktur perusahaan">
                                    </div>

                                    <div class="row">
                                        <div class="col-md-6 mb-3">
                                            <label for="sektor_id" class="form-label">Sektor (Bahasa Indonesia) <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control" id="sektor_id" name="sektor_id" required 
                                                   placeholder="Contoh: Teknologi Informasi">
                                        </div>

                                        <div class="col-md-6 mb-3">
                                            <label for="sektor_en" class="form-label">Sektor (Bahasa Inggris) <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control" id="sektor_en" name="sektor_en" required 
                                                   placeholder="Contoh: Information Technology">
                                        </div>
                                    </div>

                                    <div class="mb-3">
                                        <label for="tahun_berlaku" class="form-label">Tahun Berlaku <span class="text-danger">*</span></label>
                                        <select class="form-select" id="tahun_berlaku" name="tahun_berlaku" required>
                                            <option value="">Pilih Tahun Berlaku</option>
                                            <?php for ($i = 1; $i <= 20; $i++): ?>
                                                <option value="<?php echo $i; ?>"><?php echo $i; ?> Tahun</option>
                                            <?php endfor; ?>
                                        </select>
                                    </div>

                                    <div class="mb-3">
                                        <label for="alamat" class="form-label">Alamat <span class="text-danger">*</span></label>
                                        <textarea class="form-control" id="alamat" name="alamat" rows="3" required 
                                                  placeholder="Masukkan alamat lengkap perusahaan"></textarea>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-6 mb-3">
                                            <label for="nilai" class="form-label">Nilai (%) <span class="text-danger">*</span></label>
                                            <div class="input-group">
                                                <input type="number" class="form-control" id="nilai" name="nilai" required 
                                                       step="0.01" min="0" max="100" placeholder="89.54">
                                                <span class="input-group-text">%</span>
                                            </div>
                                            <div class="form-text">Contoh: 89.54</div>
                                        </div>

                                        <div class="col-md-6 mb-3">
                                            <label for="jumlah_kriteria" class="form-label">Jumlah Kriteria <span class="text-danger">*</span></label>
                                            <input type="number" class="form-control" id="jumlah_kriteria" name="jumlah_kriteria" required 
                                                   min="1" placeholder="86">
                                            <div class="form-text">Contoh: 86</div>
                                        </div>
                                    </div>

                                    <div class="mb-4">
                                        <label for="tanggal" class="form-label">Tanggal <span class="text-danger">*</span></label>
                                        <input type="date" class="form-control" id="tanggal" name="tanggal" 
                                               value="<?php echo date('Y-m-d'); ?>" required>
                                    </div>

                                    <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                                        <a href="index.php" class="btn btn-secondary me-md-2">
                                            <i class="fas fa-arrow-left me-1"></i>Kembali
                                        </a>
                                        <button type="reset" class="btn btn-outline-secondary me-md-2">
                                            <i class="fas fa-undo me-1"></i>Reset
                                        </button>
                                        <button type="submit" name="submit" class="btn btn-primary">
                                            <i class="fas fa-save me-1"></i>Simpan Permohonan
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </main>
        </div>
    </div>
</body>
</html>
<?php mysqli_close($conn); ?>