    <!-- Sidebar HTML Structure -->
    <button class="hamburger-menu" id="hamburgerMenu">
        <i class="fas fa-bars"></i>
    </button>
    <div class="sidebar-overlay" id="sidebarOverlay"></div>
    <div class="sidebar" id="sidebar">
        <div class="sidebar-header d-flex align-items-center justify-content-center gap-2 mb-4">
            <img src="../assets/img/logo.png" alt="Logo" class="sidebar-logo" width="50" height="50">
            <h3 class="text-white m-0">LAMSKK</h3>
        </div>
        <nav class="d-flex flex-column">
            <!-- Menu Perorangan -->
            <div class="sidebar-dropdown">
                <a href="#" class="sidebar-link sidebar-dropdown-toggle <?php echo (in_array(basename($_SERVER['PHP_SELF']), ['tambah_perorangan.php', 'approve_perorangan.php'])) ? 'active' : ''; ?>" onclick="toggleDropdown('perorangan')" id="toggle-perorangan">
                    <i class="fas fa-user me-2"></i>
                    <span>Perorangan</span>
                </a>
                <div class="dropdown-content" id="dropdown-perorangan" style="<?php echo (in_array(basename($_SERVER['PHP_SELF']), ['tambah_perorangan.php', 'approve_perorangan.php'])) ? 'display: block;' : 'display: none;'; ?>">
                    <a href="tambah_perorangan.php" class="sidebar-sublink <?php echo (basename($_SERVER['PHP_SELF']) == 'tambah_perorangan.php') ? 'active' : ''; ?>">
                        <i class="fas fa-plus me-2"></i>
                        <span>Form Perorangan</span>
                    </a>
                    <a href="approve_perorangan.php" class="sidebar-sublink <?php echo (basename($_SERVER['PHP_SELF']) == 'approve_perorangan.php') ? 'active' : ''; ?>">
                        <i class="fas fa-table me-2"></i>
                        <span>Tabel Perorangan</span>
                    </a>
                </div>
            </div>

            <!-- Menu Badan Usaha -->
            <div class="sidebar-dropdown">
                <a href="#" class="sidebar-link sidebar-dropdown-toggle <?php echo (in_array(basename($_SERVER['PHP_SELF']), ['tambah_badan_usaha.php', 'approve_badan_usaha.php'])) ? 'active' : ''; ?>" onclick="toggleDropdown('badan_usaha')" id="toggle-badan_usaha">
                    <i class="fas fa-building me-2"></i>
                    <span>Badan Usaha</span>
                </a>
                <div class="dropdown-content" id="dropdown-badan_usaha" style="<?php echo (in_array(basename($_SERVER['PHP_SELF']), ['tambah_badan_usaha.php', 'approve_badan_usaha.php'])) ? 'display: block;' : 'display: none;'; ?>">
                    <a href="tambah_badan_usaha.php" class="sidebar-sublink <?php echo (basename($_SERVER['PHP_SELF']) == 'tambah_badan_usaha.php') ? 'active' : ''; ?>">
                        <i class="fas fa-plus me-2"></i>
                        <span>Form Badan Usaha</span>
                    </a>
                    <a href="approve_badan_usaha.php" class="sidebar-sublink <?php echo (basename($_SERVER['PHP_SELF']) == 'approve_badan_usaha.php') ? 'active' : ''; ?>">
                        <i class="fas fa-table me-2"></i>
                        <span>Tabel Badan Usaha</span>
                    </a>
                </div>
            </div>

            <a href="add_admin.php" class="sidebar-link <?php echo (basename($_SERVER['PHP_SELF']) == 'add_admin.php') ? 'active' : ''; ?>">
                <i class="fas fa-user-plus me-2"></i>
                <span>Tambah Admin</span>
            </a>
            <a href="logout.php" class="sidebar-link logout-btn mt-auto">
                <i class="fas fa-sign-out-alt me-2"></i>
                <span>Logout</span>
            </a>
        </nav>
    </div>

    <style>
        /* Sidebar Styles */
        .sidebar {
            height: 100vh;
            width: 250px;
            position: fixed;
            top: 0;
            left: -250px; /* Sidebar tersembunyi secara default */
            background-color: #343a40;
            z-index: 1000;
            transition: left 0.3s ease;
            display: flex;
            flex-direction: column;
        }

        .sidebar-header {
            padding: 1.5rem 1rem;
        }

        .sidebar-logo {
            object-fit: contain;
        }

        .sidebar nav {
            flex: 1;
            display: flex;
            flex-direction: column;
        }

        .sidebar-link {
            color: #fff;
            text-decoration: none;
            padding: 0.875rem 1.5rem;
            display: flex;
            align-items: center;
            transition: all 0.3s ease;
            border-left: 4px solid transparent;
        }

        .sidebar-link:hover {
            background-color: rgba(255, 255, 255, 0.1);
            color: #fff;
        }

        .sidebar-link.active {
            background-color: #575757;
            border-left: 4px solid #f71c1c;
            color: #fff;
        }

        .sidebar-link i {
            width: 20px;
            text-align: center;
            margin-right: 10px;
        }

        .logout-btn {
            margin-top: auto;
        }

        /* Dropdown Styles */
        .sidebar-dropdown {
            position: relative;
        }

        .sidebar-dropdown-toggle {
            position: relative;
        }

        .sidebar-dropdown-toggle::after {
            content: '\f078'; /* FontAwesome chevron-down */
            font-family: 'Font Awesome 6 Free';
            font-weight: 900;
            position: absolute;
            right: 1.5rem;
            top: 50%;
            transform: translateY(-50%);
            transition: transform 0.3s ease;
            font-size: 12px;
        }

        .sidebar-dropdown-toggle.open::after {
            transform: translateY(-50%) rotate(180deg);
        }

        .dropdown-content {
            overflow: hidden;
            transition: all 0.3s ease;
            background-color: rgba(0, 0, 0, 0.2);
        }

        .sidebar-sublink {
            color: #ccc;
            text-decoration: none;
            padding: 0.75rem 2rem;
            display: flex;
            align-items: center;
            transition: all 0.3s ease;
            border-left: 4px solid transparent;
            font-size: 0.9rem;
        }

        .sidebar-sublink:hover {
            background-color: rgba(255, 255, 255, 0.1);
            color: #fff;
        }

        .sidebar-sublink.active {
            background-color: #495057;
            border-left: 4px solid #28a745;
            color: #fff;
        }

        .sidebar-sublink i {
            width: 16px;
            text-align: center;
            margin-right: 8px;
            font-size: 12px;
        }

        /* Hamburger menu styles */
        .hamburger-menu {
            display: none;
            
            top: 20px;
            left: 20px; /* Letakkan tombol di luar sidebar */
            z-index: 1001;
            background: white;
            border: 0px solid #ddd;
            color: #343a40;
            font-size: 24px;
            cursor: pointer;
            padding: 8px 12px;
            border-radius: 4px;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.2);
        }

        /* Sidebar overlay */
        .sidebar-overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: rgba(0, 0, 0, 0.5);
            z-index: 999;
        }

        .sidebar-overlay.active {
            display: block;
        }

        /* Desktop view */
        @media (min-width: 769px) {
            .sidebar {
                left: 0; /* Sidebar tetap terbuka */
            }
            .content {
                margin-left: 250px; /* Konten bergeser ke kanan untuk memberi ruang sidebar */
            }
            .hamburger-menu {
                display: none; /* Sembunyikan hamburger pada desktop */
            }
        }

        /* Mobile view */
        @media (max-width: 768px) {
            .hamburger-menu {
                display: block; /* Tampilkan hamburger hanya di perangkat mobile */
            }
            .content {
                margin-left: 0;
                padding-top: 70px; /* Memberikan ruang untuk hamburger menu */
            }
            .sidebar {
                left: -250px; /* Sidebar tersembunyi */
            }
            .sidebar.active {
                left: 0; /* Sidebar muncul */
            }
        }
    </style>

<script>
        // Function untuk toggle dropdown
        function toggleDropdown(menuType) {
            const dropdown = document.getElementById('dropdown-' + menuType);
            const toggle = document.getElementById('toggle-' + menuType);
            
            if (dropdown.style.display === 'none' || dropdown.style.display === '') {
                dropdown.style.display = 'block';
                toggle.classList.add('open');
            } else {
                dropdown.style.display = 'none';
                toggle.classList.remove('open');
            }
        }

        document.addEventListener('DOMContentLoaded', function () {
            const hamburgerMenu = document.getElementById('hamburgerMenu');
            const sidebar = document.getElementById('sidebar');
            const overlay = document.getElementById('sidebarOverlay');

            // Initialize dropdown untuk yang sudah aktif
            const activeDropdowns = document.querySelectorAll('.dropdown-content[style*="display: block"]');
            activeDropdowns.forEach(function(dropdown) {
                const menuType = dropdown.id.replace('dropdown-', '');
                const toggle = document.getElementById('toggle-' + menuType);
                if (toggle) {
                    toggle.classList.add('open');
                }
            });

            // Fungsi untuk toggle sidebar
            function toggleSidebar() {
                sidebar.classList.toggle('active');  // Menampilkan atau menyembunyikan sidebar
                overlay.classList.toggle('active');  // Menampilkan atau menyembunyikan overlay
            }

            // Event listener untuk tombol hamburger
            hamburgerMenu.addEventListener('click', function (e) {
                e.stopPropagation();  // Mencegah event bubbling
                toggleSidebar();
            });

            // Event listener untuk klik pada overlay
            overlay.addEventListener('click', function () {
                toggleSidebar();
            });

            // Menangani swipe untuk perangkat mobile
            let touchStartX = 0;
            let touchEndX = 0;

            document.addEventListener('touchstart', function (e) {
                touchStartX = e.changedTouches[0].screenX;
            }, false);

            document.addEventListener('touchend', function (e) {
                touchEndX = e.changedTouches[0].screenX;
                handleSwipe();
            }, false);

            // Fungsi untuk menangani swipe gesture
            function handleSwipe() {
                const swipeThreshold = 50;
                const swipeLength = touchEndX - touchStartX;

                if (Math.abs(swipeLength) > swipeThreshold) {
                    if (swipeLength > 0) { // Swipe kanan
                        if (!sidebar.classList.contains('active')) {
                            toggleSidebar();
                        }
                    } else { // Swipe kiri
                        if (sidebar.classList.contains('active')) {
                            toggleSidebar();
                        }
                    }
                }
            }

            // Menutup sidebar saat ukuran layar lebih besar dari 768px (desktop view)
            window.addEventListener('resize', function () {
                if (window.innerWidth > 768) {
                    sidebar.classList.remove('active');
                    overlay.classList.remove('active');
                }
            });
        });
    </script>

</body>

</html>