<?php
session_start();

require_once('../config/db.php');

if (!isset($_SESSION['admin_logged_in'])) {
    header('Location: login.php');
    exit();
}

// Handle actions
if (isset($_POST['action']) && isset($_POST['id'])) {
    $action = $_POST['action'];
    $id = (int) $_POST['id'];

    if (!is_numeric($id) || $id <= 0) {
        echo "Invalid ID.";
        exit();
    }

    if ($action === 'approve') {
        $query = "UPDATE permohonan_sertifikasi SET status = 'approved' WHERE id = $id";
    } elseif ($action === 'reject') {
        $query = "UPDATE permohonan_sertifikasi SET status = 'rejected' WHERE id = $id";
    } elseif ($action === 'pending') {
        $query = "UPDATE permohonan_sertifikasi SET status = 'pending' WHERE id = $id";
    } elseif ($action === 'delete') {
        $query = "DELETE FROM permohonan_sertifikasi WHERE id = $id";
    } else {
        echo "Invalid action.";
        exit();
    }

    if (mysqli_query($conn, $query)) {
        header('Location: approve_perorangan.php');
        exit();
    } else {
        echo "Error: " . mysqli_error($conn);
    }
}

// Filter conditions
$where_conditions = ["jenis_sertifikasi = 'perorangan'"];

if (isset($_GET['status']) && in_array($_GET['status'], ['pending', 'approved', 'rejected'])) {
    $status = mysqli_real_escape_string($conn, $_GET['status']);
    $where_conditions[] = "status = '$status'";
}

$where = 'WHERE ' . implode(' AND ', $where_conditions);

// Query untuk perorangan - hanya field yang dibutuhkan di sertifikat
$query = "SELECT id, no_reg, nama_pemohon, tempat_lahir, tanggal_lahir, nama_perusahaan, 
          tanggal_pengajuan, status 
          FROM permohonan_sertifikasi $where 
          ORDER BY tanggal_pengajuan DESC";
$result = mysqli_query($conn, $query);
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Approval Sertifikasi Perorangan</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
</head>

<body>
    <?php include 'sidebar.php'; ?>

    <div class="container-fluid">
        <div class="row">
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-5 mt-4 ps-5">
                <div class="d-flex justify-content-between align-items-center pb-3 mb-4 border-bottom">
                    <h1 class="h2">Approval Sertifikasi Perorangan</h1>
                    <div>
                        <?php
                        $total_filtered = mysqli_num_rows($result);
                        echo "<span class='badge bg-success fs-6'>$total_filtered Permohonan</span>";
                        ?>
                    </div>
                </div>

                <!-- Active Filters Display -->
                <?php if (isset($_GET['status'])): ?>
                    <div class="mb-3">
                        <div class="d-flex align-items-center gap-2 flex-wrap">
                            <span class="text-muted">Filter aktif:</span>
                            <span class="badge bg-<?php 
                                echo $_GET['status'] === 'pending' ? 'warning' : 
                                     ($_GET['status'] === 'approved' ? 'success' : 'danger'); 
                            ?>">
                                Status: <?php echo ucfirst($_GET['status']); ?>
                            </span>
                        </div>
                    </div>
                <?php endif; ?>

                <!-- Filter Status -->
                <div class="mb-4">
                    <form method="GET" class="row g-3 align-items-end">
                        <div class="col-auto">
                            <label for="status" class="form-label fw-semibold">Filter Status</label>
                            <select name="status" id="status" class="form-select" onchange="this.form.submit()">
                                <option value="">Semua Status</option>
                                <option value="pending" <?php echo (isset($_GET['status']) && $_GET['status'] == 'pending') ? 'selected' : ''; ?>>Pending</option>
                                <option value="approved" <?php echo (isset($_GET['status']) && $_GET['status'] == 'approved') ? 'selected' : ''; ?>>Disetujui</option>
                                <option value="rejected" <?php echo (isset($_GET['status']) && $_GET['status'] == 'rejected') ? 'selected' : ''; ?>>Ditolak</option>
                            </select>
                        </div>
                        <div class="col-auto">
                            <?php if (isset($_GET['status'])): ?>
                                <a href="approve_perorangan.php" class="btn btn-outline-secondary">
                                    <i class="fas fa-times me-1"></i>Reset Filter
                                </a>
                            <?php endif; ?>
                        </div>
                    </form>
                </div>

                <!-- Tabel Perorangan -->
                <?php if (mysqli_num_rows($result) > 0): ?>
                    <div class="table-responsive">
                        <table class="table table-hover table-bordered align-middle">
                            <thead class="table-success">
                                <tr>
                                    <th scope="col" class="text-center">No</th>
                                    <th scope="col" class="text-center">Nomor</th>
                                    <th scope="col" class="text-center">Nama</th>
                                    <th scope="col" class="text-center">Tempat Lahir</th>
                                    <th scope="col" class="text-center">Tanggal Lahir</th>
                                    <th scope="col" class="text-center">Nama Perusahaan</th>
                                    <th scope="col" class="text-center">Tanggal Pengajuan</th>
                                    <th scope="col" class="text-center">Status</th>
                                    <th scope="col" class="text-center">Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $no = 1;
                                while ($row = mysqli_fetch_assoc($result)):
                                ?>
                                    <tr>
                                        <td class="text-center"><?php echo $no++; ?></td>
                                        <td><?php echo htmlspecialchars($row['no_reg']); ?></td>
                                        <td><?php echo htmlspecialchars($row['nama_pemohon']); ?></td>
                                        <td><?php echo htmlspecialchars($row['tempat_lahir'] ?? '-'); ?></td>
                                        <td class="text-center">
                                            <?php 
                                            if ($row['tanggal_lahir']) {
                                                echo date('d/m/Y', strtotime($row['tanggal_lahir'])); 
                                            } else {
                                                echo '-';
                                            }
                                            ?>
                                        </td>
                                        <td><?php echo htmlspecialchars($row['nama_perusahaan'] ?? '-'); ?></td>
                                        <td class="text-center"><?php echo date('d/m/Y', strtotime($row['tanggal_pengajuan'])); ?></td>
                                        <td class="text-center">
                                            <span class="badge bg-<?php echo $row['status'] === 'pending' ? 'warning' :
                                                ($row['status'] === 'approved' ? 'success' : 'danger'); ?>">
                                                <?php echo ucfirst($row['status']); ?>
                                            </span>
                                        </td>
                                        <td class="text-center">
                                            <div class="btn-group" role="group">
                                                <form method="POST" class="d-inline">
                                                    <input type="hidden" name="id" value="<?php echo $row['id']; ?>">
                                                    <?php if ($row['status'] !== 'approved'): ?>
                                                        <button type="submit" name="action" value="approve"
                                                            class="btn btn-success btn-sm" title="Approve">
                                                            <i class="fas fa-check"></i>
                                                        </button>
                                                    <?php endif; ?>
                                                    
                                                    <?php if ($row['status'] !== 'pending'): ?>
                                                        <button type="submit" name="action" value="pending"
                                                            class="btn btn-warning btn-sm" title="Pending">
                                                            <i class="fas fa-hourglass"></i>
                                                        </button>
                                                    <?php endif; ?>
                                                    
                                                    <?php if ($row['status'] !== 'rejected'): ?>
                                                        <button type="submit" name="action" value="reject"
                                                            class="btn btn-danger btn-sm" title="Reject">
                                                            <i class="fas fa-times"></i>
                                                        </button>
                                                    <?php endif; ?>
                                                    
                                                    <button type="submit" name="action" value="delete"
                                                        class="btn btn-outline-danger btn-sm" title="Delete"
                                                        onclick="return confirm('Yakin ingin menghapus data ini?')">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endwhile; ?>
                            </tbody>
                        </table>
                    </div>
                <?php else: ?>
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle me-2"></i>Tidak ada permohonan sertifikasi perorangan yang ditemukan.
                    </div>
                <?php endif; ?>
            </main>
        </div>
    </div>
</body>
</html>
<?php mysqli_close($conn); ?>