<?php
// Memulai sesi untuk manajemen login
session_start();

// Konfigurasi koneksi database
require_once('../config/db.php');

// Memeriksa status login admin
if (!isset($_SESSION['admin_logged_in'])) {
    header('Location: login.php');
    exit();
}

// Menangani proses persetujuan atau penolakan permohonan
if (isset($_POST['action']) && isset($_POST['id'])) {
    $action = $_POST['action'];
    $id = (int) $_POST['id'];

    // Validasi input ID untuk keamanan
    if (!is_numeric($id) || $id <= 0) {
        echo "Invalid ID.";
        exit();
    }

    // Mengupdate status berdasarkan aksi yang dipilih
    if ($action === 'approve') {
        $query = "UPDATE permohonan_sertifikasi SET status = 'approved' WHERE id = $id";
    } elseif ($action === 'reject') {
        $query = "UPDATE permohonan_sertifikasi SET status = 'rejected' WHERE id = $id";
    } elseif ($action === 'pending') {
        $query = "UPDATE permohonan_sertifikasi SET status = 'pending' WHERE id = $id";
    } elseif ($action === 'delete') {
        $query = "DELETE FROM permohonan_sertifikasi WHERE id = $id";
    } else {
        echo "Invalid action.";
        exit();
    }

    // Eksekusi query update
    if (mysqli_query($conn, $query)) {
        header('Location: approve.php');
        exit();
    } else {
        echo "Error updating record: " . mysqli_error($conn);
    }
}

// Mengambil data dengan filter status dan jenis_sertifikasi jika ada
$where_conditions = [];

// Filter berdasarkan status
if (isset($_GET['status']) && in_array($_GET['status'], ['pending', 'approved', 'rejected'])) {
    $status = mysqli_real_escape_string($conn, $_GET['status']);
    $where_conditions[] = "status = '$status'";
}

// Filter berdasarkan jenis sertifikasi
if (isset($_GET['jenis']) && in_array($_GET['jenis'], ['badan_usaha', 'perorangan'])) {
    $jenis = mysqli_real_escape_string($conn, $_GET['jenis']);
    $where_conditions[] = "jenis_sertifikasi = '$jenis'";
}

// Gabungkan kondisi WHERE
$where = '';
if (!empty($where_conditions)) {
    $where = 'WHERE ' . implode(' AND ', $where_conditions);
}

// Query untuk mengambil semua data permohonan
$query = "SELECT id, no_reg, nama_pemohon, no_hp, email, nama_perusahaan, 
          nilai, jumlah_kriteria, jenis_sertifikasi, wilayah, tanggal_pengajuan, dokumen_path, status 
          FROM permohonan_sertifikasi $where 
          ORDER BY tanggal_pengajuan DESC";
$result = mysqli_query($conn, $query);
?>

<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Approval Permohonan Sertifikasi</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
</head>

<body>
    <?php include 'sidebar.php'; ?>

    <div class="container-fluid">
        <div class="row">
            <!-- Konten Utama -->
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-5 mt-4 ps-5">
                <div class="d-flex justify-content-between align-items-center pb-3 mb-4 border-bottom">
                    <h1 class="h2">Approval Permohonan Sertifikasi</h1>
                    <div>
                        <?php
                        $total_filtered = mysqli_num_rows($result);
                        echo "<span class='badge bg-secondary fs-6'>$total_filtered Permohonan</span>";
                        ?>
                    </div>
                </div>

                <!-- Active Filters Display -->
                <?php if (isset($_GET['status']) || isset($_GET['jenis'])): ?>
                    <div class="mb-3">
                        <div class="d-flex align-items-center gap-2 flex-wrap">
                            <span class="text-muted">Filter aktif:</span>
                            <?php if (isset($_GET['status'])): ?>
                                <span class="badge bg-<?php 
                                    echo $_GET['status'] === 'pending' ? 'warning' : 
                                         ($_GET['status'] === 'approved' ? 'success' : 'danger'); 
                                ?>">
                                    Status: <?php echo ucfirst($_GET['status']); ?>
                                </span>
                            <?php endif; ?>
                            <?php if (isset($_GET['jenis'])): ?>
                                <span class="badge bg-<?php echo $_GET['jenis'] === 'badan_usaha' ? 'primary' : 'info'; ?>">
                                    Jenis: <?php echo $_GET['jenis'] === 'badan_usaha' ? 'Badan Usaha' : 'Perorangan'; ?>
                                </span>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endif; ?>

                <!-- Filter Status dan Jenis Sertifikasi -->
                <div class="mb-4">
                    <form method="GET" class="row g-3 align-items-end">
                        <div class="col-auto">
                            <label for="status" class="form-label fw-semibold">Filter Status</label>
                            <select name="status" id="status" class="form-select" onchange="submitFilter()">
                                <option value="">Semua Status</option>
                                <option value="pending" <?php echo (isset($_GET['status']) && $_GET['status'] == 'pending') ? 'selected' : ''; ?>>Pending</option>
                                <option value="approved" <?php echo (isset($_GET['status']) && $_GET['status'] == 'approved') ? 'selected' : ''; ?>>Disetujui</option>
                                <option value="rejected" <?php echo (isset($_GET['status']) && $_GET['status'] == 'rejected') ? 'selected' : ''; ?>>Ditolak</option>
                            </select>
                        </div>
                        <div class="col-auto">
                            <label for="jenis" class="form-label fw-semibold">Filter Jenis</label>
                            <select name="jenis" id="jenis" class="form-select" onchange="submitFilter()">
                                <option value="">Semua Jenis</option>
                                <option value="badan_usaha" <?php echo (isset($_GET['jenis']) && $_GET['jenis'] == 'badan_usaha') ? 'selected' : ''; ?>>Badan Usaha</option>
                                <option value="perorangan" <?php echo (isset($_GET['jenis']) && $_GET['jenis'] == 'perorangan') ? 'selected' : ''; ?>>Perorangan</option>
                            </select>
                        </div>
                        <div class="col-auto">
                            <?php if (isset($_GET['status']) || isset($_GET['jenis'])): ?>
                                <a href="approve.php" class="btn btn-outline-secondary">
                                    <i class="fas fa-times me-1"></i>Reset Filter
                                </a>
                            <?php endif; ?>
                        </div>
                    </form>
                </div>

                <!-- Bagian Tabel -->
                <?php if (mysqli_num_rows($result) > 0): ?>
                    <div class="table-responsive">
                        <table class="table table-hover table-bordered align-middle">
                            <thead class="table-light">
                                <tr>
                                    <th scope="col" class="text-center align-middle" style="height: 60px; width: 50px;">No
                                    </th>
                                    <th scope="col" class="text-center align-middle" style="height: 60px;">No Reg</th>
                                    <th scope="col" class="text-center align-middle">Nama<br>Pemohon</th>
                                    <th scope="col" class="text-center align-middle">No HP</th>
                                    <th scope="col" class="text-center align-middle">Email</th>
                                    <th scope="col" class="text-center align-middle">Perusahaan</th>
                                    <th scope="col" class="text-center align-middle">Nilai</th>
                                    <th scope="col" class="text-center align-middle">Kriteria</th>
                                    <th scope="col" class="text-center align-middle">Jenis</th>
                                    <th scope="col" class="text-center align-middle">Wilayah</th>
                                    <th scope="col" class="text-center align-middle">Tanggal</th>
                                    <th scope="col" class="text-center align-middle">Status</th>
                                    <th scope="col" class="text-center align-middle">Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                // Initialize the counter before the loop
                                $no = 1;
                                while ($row = mysqli_fetch_assoc($result)):
                                    ?>
                                    <tr>
                                        <td class="text-center"><?php echo $no++; ?></td>
                                        <td><?php echo htmlspecialchars($row['no_reg']); ?></td>
                                        <td><?php echo htmlspecialchars($row['nama_pemohon']); ?></td>
                                        <td><?php echo htmlspecialchars($row['no_hp']); ?></td>
                                        <td><?php echo htmlspecialchars($row['email']); ?></td>
                                        <td><?php echo htmlspecialchars($row['nama_perusahaan']); ?></td>
                                        <td>
                                            <?php if ($row['nilai']): ?>
                                                <span class="badge bg-success"><?php echo number_format($row['nilai'], 2); ?>%</span>
                                            <?php else: ?>
                                                <span class="text-muted">-</span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php if ($row['jumlah_kriteria']): ?>
                                                <span class="badge bg-info"><?php echo $row['jumlah_kriteria']; ?></span>
                                            <?php else: ?>
                                                <span class="text-muted">-</span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <span class="badge bg-<?php echo $row['jenis_sertifikasi'] === 'badan_usaha' ? 'primary' : 'info'; ?>">
                                                <?php echo $row['jenis_sertifikasi'] === 'badan_usaha' ? 'Badan Usaha' : 'Perorangan'; ?>
                                            </span>
                                        </td>
                                        <td><?php echo htmlspecialchars($row['wilayah']); ?></td>
                                        <td><?php echo date('d/m/Y', strtotime($row['tanggal_pengajuan'])); ?></td>
                                        <td>
                                            <span class="badge bg-<?php echo $row['status'] === 'pending' ? 'warning' :
                                                ($row['status'] === 'approved' ? 'success' : 'danger'); ?>">
                                                <?php echo ucfirst($row['status']); ?>
                                            </span>
                                        </td>
                                        <td>
                                            <?php if ($row['status'] === 'pending'): ?>
                                                <div class="btn-group" role="group">
                                                    <form method="POST" class="d-inline">
                                                        <input type="hidden" name="id" value="<?php echo $row['id']; ?>">
                                                        <button type="submit" name="action" value="approve"
                                                            class="btn btn-success btn-sm">
                                                            <i class="fas fa-check"></i>
                                                        </button>
                                                        <button type="submit" name="action" value="reject"
                                                            class="btn btn-danger btn-sm">
                                                            <i class="fas fa-times"></i>
                                                        </button>
                                                        <button type="submit" name="action" value="delete"
                                                            class="btn btn-outline-danger btn-sm"
                                                            onclick="return confirm('Yakin ingin menghapus data ini?')">
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    </form>
                                                </div>
                                            <?php elseif ($row['status'] === 'approved'): ?>
                                                <div class="btn-group" role="group">
                                                    <form method="POST" class="d-inline">
                                                        <input type="hidden" name="id" value="<?php echo $row['id']; ?>">
                                                        <button type="submit" name="action" value="pending"
                                                            class="btn btn-warning btn-sm">
                                                            <i class="fas fa-hourglass"></i>
                                                        </button>
                                                        <button type="submit" name="action" value="reject"
                                                            class="btn btn-danger btn-sm">
                                                            <i class="fas fa-times"></i>
                                                        </button>
                                                        <button type="submit" name="action" value="delete"
                                                            class="btn btn-outline-danger btn-sm"
                                                            onclick="return confirm('Yakin ingin menghapus data ini?')">
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    </form>
                                                </div>
                                            <?php elseif ($row['status'] === 'rejected'): ?>
                                                <div class="btn-group" role="group">
                                                    <form method="POST" class="d-inline">
                                                        <input type="hidden" name="id" value="<?php echo $row['id']; ?>">
                                                        <button type="submit" name="action" value="approve"
                                                            class="btn btn-success btn-sm">
                                                            <i class="fas fa-check"></i>
                                                        </button>
                                                        <button type="submit" name="action" value="pending"
                                                            class="btn btn-warning btn-sm">
                                                            <i class="fas fa-hourglass"></i>
                                                        </button>
                                                        <button type="submit" name="action" value="delete"
                                                            class="btn btn-outline-danger btn-sm"
                                                            onclick="return confirm('Yakin ingin menghapus data ini?')">
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    </form>
                                                </div>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endwhile; ?>
                            </tbody>
                        </table>
                    </div>
                <?php else: ?>
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle me-2"></i>Tidak ada permohonan sertifikasi yang ditemukan.
                    </div>
                <?php endif; ?>
            </main>
        </div>
    </div>
    <script>
        function submitFilter() {
            const form = document.querySelector('form');
            const statusSelect = document.getElementById('status');
            const jenisSelect = document.getElementById('jenis');
            
            // Build URL with current filter values
            const params = new URLSearchParams();
            
            if (statusSelect.value) {
                params.append('status', statusSelect.value);
            }
            
            if (jenisSelect.value) {
                params.append('jenis', jenisSelect.value);
            }
            
            // Redirect with new parameters
            window.location.href = 'approve.php' + (params.toString() ? '?' + params.toString() : '');
        }
    </script>
</body>

</html>

<?php mysqli_close($conn); ?>
