<?php
session_start();

// Security check - Ensure only logged in admins can access
if (!isset($_SESSION['admin_logged_in'])) {
    header('Location: login.php');
    exit();
}

// Database connection configuration
require_once('../config/db.php');

// Initialize variables for messages and edit mode
$success = '';
$error = '';
$edit_mode = false;
$edit_id = 0;

// Handle form submission for adding or updating admin
// Handle form submission for adding or updating admin
if (isset($_POST['save_admin'])) {
    $username = mysqli_real_escape_string($conn, $_POST['username']);
    $password = mysqli_real_escape_string($conn, $_POST['password']);
    $confirm_password = mysqli_real_escape_string($conn, $_POST['confirm_password']);

    // Validate password match
    if ($password !== $confirm_password) {
        $error = "Password tidak cocok!";
    } else {
        if (isset($_POST['edit_id']) && $_POST['edit_id'] != '') {
            // Update existing admin
            $edit_id = intval($_POST['edit_id']);
            $hashed_password = password_hash($password, PASSWORD_BCRYPT); // Hash password using bcrypt
            $query = "UPDATE admin SET username = '$username', password = '$hashed_password' WHERE id = $edit_id";
            if (mysqli_query($conn, $query)) {
                $success = "Admin berhasil diperbarui!";
            } else {
                $error = "Error: " . mysqli_error($conn);
            }
        } else {
            // Check for duplicate username before adding new admin
            $check_query = "SELECT * FROM admin WHERE username = '$username'";
            $result = mysqli_query($conn, $check_query);

            if (mysqli_num_rows($result) > 0) {
                $error = "Username sudah digunakan!";
            } else {
                // Hash the password using bcrypt
                $hashed_password = password_hash($password, PASSWORD_BCRYPT);
                $query = "INSERT INTO admin (username, password) VALUES ('$username', '$hashed_password')";
                if (mysqli_query($conn, $query)) {
                    $success = "Admin berhasil ditambahkan!";
                } else {
                    $error = "Error: " . mysqli_error($conn);
                }
            }
        }
    }
}

// Handle admin deletion
if (isset($_GET['delete_id'])) {
    $delete_id = intval($_GET['delete_id']);
    $delete_query = "DELETE FROM admin WHERE id = $delete_id";
    mysqli_query($conn, $delete_query);
    header('Location: add_admin.php');
    exit();
}

// Fetch all admin records
$query = "SELECT id, username, password FROM admin ORDER BY id DESC";
$admins = mysqli_query($conn, $query);
?>

<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tambah Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    
    <!-- Custom CSS for action buttons -->
    <style>
        .btn-group {
            display: inline-flex;
            gap: 5px;
        }
        
        .btn-group .btn {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            min-width: 80px;
            padding: 0.375rem 0.75rem;
        }

        .action-buttons {
            white-space: nowrap;
        }

        .table td {
            vertical-align: middle;
        }
    </style>
</head>

<body>
    <?php include 'sidebar.php'; ?>

    <div class="container-fluid">
        <div class="row">
            <main class="col-md-9 ms-sm-auto col-lg-10 px-5 mt-4">
                <div class="d-flex justify-content-between align-items-center pb-3 mb-4 border-bottom">
                    <h2>Daftar Admin</h2>
                </div>

                <!-- Display success/error messages -->
                <?php if ($success): ?>
                    <div class="alert alert-success alert-dismissible fade show mb-4" role="alert">
                        <i class="fas fa-check-circle me-2"></i><?php echo $success; ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                <?php endif; ?>

                <?php if ($error): ?>
                    <div class="alert alert-danger alert-dismissible fade show mb-4" role="alert">
                        <i class="fas fa-exclamation-circle me-2"></i><?php echo $error; ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                <?php endif; ?>

                <!-- Add Admin Button -->
                <button class="btn btn-primary mb-4" data-bs-toggle="modal" data-bs-target="#adminModal">
                    <i class="fas fa-user-plus me-2"></i>Tambah Admin
                </button>

                <!-- Admin Table -->
                <div class="table-responsive">
                    <table class="table table-hover table-bordered">
                        <thead class="table-light">
                            <tr>
                                <th scope="col" class="text-center py-3">ID</th>
                                <th scope="col" class="text-center py-3">Username</th>
                                <th scope="col" class="text-center py-3">Password</th>
                                <th scope="col" class="text-center py-3" style="min-width: 200px;">Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while ($row = mysqli_fetch_assoc($admins)): ?>
                                <tr>
                                    <td class="text-center"><?php echo $row['id']; ?></td>
                                    <td><?php echo htmlspecialchars($row['username']); ?></td>
                                    <td><?php echo htmlspecialchars($row['password']); ?></td>
                                    <td class="text-center">
                                        <div class="btn-group action-buttons" role="group" aria-label="Admin actions">
                                            <button type="button" 
                                                    class="btn btn-warning btn-sm" 
                                                    data-bs-toggle="modal"
                                                    data-bs-target="#adminModal"
                                                    onclick="editAdmin(<?php echo $row['id']; ?>, '<?php echo $row['username']; ?>', '<?php echo $row['password']; ?>')"
                                                    title="Edit Admin">
                                                <i class="fas fa-edit"></i>
                                                <span class="ms-1">Edit</span>
                                            </button>
                                            <a href="add_admin.php?delete_id=<?php echo $row['id']; ?>"
                                               class="btn btn-danger btn-sm"
                                               onclick="return confirm('Yakin ingin menghapus admin ini?');"
                                               title="Hapus Admin">
                                                <i class="fas fa-trash"></i>
                                                <span class="ms-1">Hapus</span>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
            </main>
        </div>
    </div>

    <!-- Admin Modal Form -->
    <div class="modal fade" id="adminModal" tabindex="-1" aria-labelledby="adminModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <form method="POST" class="modal-content">
                <div class="modal-header bg-dark text-white">
                    <h5 class="modal-title" id="adminModalLabel">Tambah Admin</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body p-4">
                    <input type="hidden" name="edit_id" id="edit_id">
                    <div class="mb-3">
                        <label class="form-label">Username</label>
                        <input type="text" name="username" id="username" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Password</label>
                        <input type="password" name="password" id="password" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Konfirmasi Password</label>
                        <input type="password" name="confirm_password" id="confirm_password" class="form-control" required>
                    </div>
                </div>
                <div class="modal-footer bg-light">
                    <button type="submit" name="save_admin" class="btn btn-primary">
                        <i class="fas fa-save me-1"></i>Simpan
                    </button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                        <i class="fas fa-times me-1"></i>Batal
                    </button>
                </div>
            </form>
        </div>
    </div>

    <script>
        function editAdmin(id, username, password) {
            document.getElementById('edit_id').value = id;
            document.getElementById('username').value = username;
            document.getElementById('password').value = password;
            document.getElementById('confirm_password').value = password;
            document.getElementById('adminModalLabel').innerText = 'Edit Admin';
        }
    </script>
</body>

</html>
<?php mysqli_close($conn); ?>