# CLAUDE.md

This file provides guidance to Claude Code (claude.ai/code) when working with code in this repository.

## Project Overview

This is a PHP-based certificate management system called "sistem-lsmkk" (System LSMKK - likely Lembaga Sertifikasi Manajemen Kualitas Komunikasi). The application manages certificate applications and generates PDF certificates using FPDF.

## Development Commands

### Dependencies
```bash
# Install PHP dependencies using Composer
composer install
```

### Running the Application
- This is a traditional PHP application that requires a web server (Apache/Nginx) and MySQL database
- Access via web browser at the configured virtual host or localhost
- Main entry points:
  - `/index.php` - Main application entry with session routing
  - `/public/form.php` - Public certificate application form  
  - `/admin/login.php` - Admin login interface

### Database Setup
- Database: MySQL/MariaDB
- Connection configured in `/config/db.php` 
- Production database credentials are in `/public/form.php` and `/admin/login.php`
- Main table: `permohonan_sertifikasi` (certificate applications)
- Admin table: `admin` (admin users with hashed passwords)

## Architecture

### Directory Structure
- `/admin/` - Admin panel with approval/rejection functionality
- `/public/` - Public-facing forms and certificate generation
- `/config/` - Database configuration
- `/assets/` - Static files (CSS, images, logos)
- `/fpdf.php` + `/font/` + `/doc/` - FPDF library for PDF generation
- `/tutorial/` - FPDF tutorials and examples

### Key Components

1. **Session Management**: Role-based routing in `index.php:10-16`
   - Administrator -> `page_admin/`
   - Member -> `page_member/`
   - No session -> `login/`

2. **Certificate Application Flow**:
   - Public form submission in `/public/form.php`
   - Admin approval/rejection in `/admin/approve.php` and `/admin/reject.php`
   - PDF certificate generation in `/public/sertifikat.php`

3. **Database Integration**: 
   - Uses mysqli with prepared statement escaping
   - Two different database configurations (development vs production)

4. **PDF Generation**:
   - Custom FPDF class extension in `/public/sertifikat.php:15-26`
   - Background image overlay from `/assets/img/bg-asset.png`
   - Indonesian date formatting function

### Security Considerations
- Uses `mysqli_real_escape_string()` for SQL injection prevention
- Password hashing with `password_verify()` in admin login
- Session-based authentication
- Input validation for required fields and email format

### Database Configuration Files
- `/config/db.php` - Development database (localhost/ServBay.dev)
- Hardcoded production credentials in `/public/form.php:4-6` and `/admin/login.php:14-17`

## Development Notes
- Traditional PHP application without modern framework
- Direct SQL queries without ORM
- Inline CSS and minimal frontend dependencies (Bootstrap CDN)
- Multiple database connection configurations suggest development/production environment differences
- always use bahasa indonesia for content languages of this project